/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8272;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class AddrFilterCreate
implements JDMWizardPanelDelegate {
    private static String bundleName = "ibm.nways.jdm8272.GeneralResources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int RASID = 19;
    private static final int RASSUB = 22;
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    GenModel model;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("ibm8272TsFilterStationAddress", new OctetString(""));
        hashtable.put("ibm8272TsFilterPorts", new OctetString("00000000"));
        hashtable.put("ibm8272TsFilterMask", new OctetString("00000000"));
        hashtable.put("ibm8272TsFilterType", new Integer(1));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        int n = 100;
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        boolean bl = true;
        GenModel genModel = jDMWizardInfo.getModel();
        Hashtable hashtable = jDMWizardInfo.getItems();
        ModelInfo modelInfo = new ModelInfo();
        Vector vector = null;
        if (genModel != null) {
            try {
                vector = genModel.getRestOfInfo("_Empty", "default", null, null);
            }
            catch (Exception exception) {
                RAS.logError(19, 22, this, "proceed", "EXCEPTION_GETTING_MODELINFO", (Object)"_Empty", (Object)"Jdm8272Model");
                RAS.logException(19, 22, this, "proceed", exception);
            }
        }
        if (vector.size() == n) {
            this.displayMsg(AddrFilterCreate.getNLSString("ADDRFLT_tableFull"));
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "proceed", "Address Filter table is full.");
            }
            if (this.browser != null) {
                this.displayMsg(AddrFilterCreate.getNLSString("ADDRFLT_tableFull"));
            }
            return false;
        }
        modelInfo.add("Index.Ibm8272TsFilterType", (Serializable)hashtable.get("ibm8272TsFilterType"));
        modelInfo.add("Index.Ibm8272TsFilterStationAddress", (Serializable)hashtable.get("ibm8272TsFilterStationAddress"));
        modelInfo.add("Panel.Ibm8272TsFilterPorts", (Serializable)hashtable.get("ibm8272TsFilterPorts"));
        modelInfo.add("Panel.Ibm8272TsFilterMask", (Serializable)hashtable.get("ibm8272TsFilterMask"));
        try {
            modelInfo = genModel.setInfo("Panel", modelInfo);
            Enumeration enumeration = modelInfo.getItemIds();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Serializable serializable = modelInfo.get(string);
                if (!(serializable instanceof SpecialValue)) continue;
                this.displayMsg(AddrFilterCreate.getNLSString("TRP_createError"));
                if (RAS.isEnabled(19, 22)) {
                    RAS.trace(19, 22, this, "proceed", "Address Filter table create row error.");
                }
                if (this.browser != null) {
                    this.displayMsg(AddrFilterCreate.getNLSString("TRP_createError"));
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
            RAS.logException(19, 22, this, "proceed", exception);
        }
        return bl;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

